import { __ } from '@wordpress/i18n';

export const pageNames = {
	about: {
		// translators: This string represents the title of an "About" page on a website that provides information about the website or organization. Please translate it in a way that fits the standard phrasing for an "About" page in the target language, considering the common usage in websites for that language.
		title: __('About', 'extendify-local'),
		// translators: This string represents the slug of an "About" page on a website that provides information about the website or organization. Please translate it in a way that fits a slug for an "About" page in the target language, considering the common usage in websites for that language.
		slug: __('about', 'extendify-local'),
		alias: ['about', 'about-us', 'recognition', 'stats'],
	},
	blog: {
		// translators: This string represents the title of a "Blog" page on a website that shows recent blog posts. Please translate it in a way that fits the standard phrasing for a "Blog" page in the target language, considering the common usage in websites for that language.
		title: __('Blog', 'extendify-local'),
		// translators: This string represents the slug of a "Blog" page on a website that shows recent blog posts. Please translate it in a way that fits a slug for a "Blog" page in the target language, considering the common usage in websites for that language.
		slug: __('blog', 'extendify-local'),
		alias: ['blog', 'blog-categories', 'blog-section'],
	},
	book: {
		// translators: This string represents the title of a "Book" page on a website that is meant for booking something. Please translate it in a way that fits the standard phrasing for a "Book" page in the target language, considering the common usage in websites for that language.
		title: __('Book', 'extendify-local'),
		alias: ['book', 'booking'],
	},
	careers: {
		// translators: This string represents the title of a "Careers" page on a website that is meant for listing available careers. Please translate it in a way that fits the standard phrasing for a "Careers" page in the target language, considering the common usage in websites for that language.
		title: __('Careers', 'extendify-local'),
		// translators: This string represents the slug of a "Careers" page on a website that is meant for listing available careers. Please translate it in a way that fits a slug for a "Careers" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('careers', 'extendify-local'),
		alias: ['careers', 'career', 'career-with-opening'],
	},
	contact: {
		// translators: This string represents the title of a "Contact" page on a website that gives information for visitors on how to contact the website or organization. Please translate it in a way that fits the standard phrasing for a "Contact" page in the target language, considering the common usage in websites for that language.
		title: __('Contact', 'extendify-local'),
		// translators: This string represents the slug of a "Contact" page on a website that gives information for visitors on how to contact the website or organization. Please translate it in a way that fits a slug for a "Contact" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('contact', 'extendify-local'),
		alias: ['contact', 'contact-with-form'],
	},
	events: {
		// translators: This string represents the title of an "Events" page on a website that lists events of any kind. Please translate it in a way that fits the standard phrasing for an "Events" page in the target language, considering the common usage in websites for that language.
		title: __('Events', 'extendify-local'),
		// translators: This string represents the slug of an "Events" page on a website that lists events of any kind. Please translate it in a way that fits a slug for an "Events" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('events', 'extendify-local'),
		alias: ['events', 'events-section'],
	},
	faq: {
		// translators: This string represents the title of a "FAQ" page on a website that gives information related to frequently asked questions. Please translate it in a way that fits the standard phrasing for a "FAQ" page in the target language, considering the common usage in websites for that language.
		title: __('FAQ', 'extendify-local'),
		// translators: This string represents the slug of a "FAQ" page on a website that gives information related to frequently asked questions. Please translate it in a way that fits a slug for a "FAQ" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('faq', 'extendify-local'),
		alias: ['faq'],
	},
	features: {
		// translators: This string represents the title of a "Features" page on a website that lists features of a product or service. Please translate it in a way that fits the standard phrasing for a "Features" page in the target language, considering the common usage in websites for that language.
		title: __('Features', 'extendify-local'),
		// translators: This string represents the slug of a "Features" page on a website that lists features of a product or service. Please translate it in a way that fits a slug for a "Features" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('features', 'extendify-local'),
		alias: ['features'],
	},
	gallery: {
		// translators: This string represents the title of a "Gallery" page on a website that shows a collection of images. Please translate it in a way that fits the standard phrasing for a "Gallery" page in the target language, considering the common usage in websites for that language.
		title: __('Gallery', 'extendify-local'),
		// translators: This string represents the slug of a "Gallery" page on a website that shows a collection of images. Please translate it in a way that fits a slug for a "Gallery" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('gallery', 'extendify-local'),
		alias: ['gallery'],
	},
	home: {
		// translators: This string represents the title of an "Home" page on a website. Please translate it in a way that fits the standard phrasing for a "Home" page in the target language, considering the common usage in websites for that language.
		title: __('Home', 'extendify-local'),
		alias: ['home'],
	},
	menu: {
		// translators: This string represents the title of a "Menu" page on a website that lists food or drink items. Please translate it in a way that fits the standard phrasing for a "Menu" page in the target language, considering the common usage in websites for that language.
		title: __('Menu', 'extendify-local'),
		// translators: This string represents the slug of a "Menu" page on a website that lists food or drink items. Please translate it in a way that fits a slug for a "Menu" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('menu', 'extendify-local'),
		alias: ['menu'],
	},
	porfolio: {
		// translators: This string represents the title of a "Portfolio" page on a website that showcases a collection of work. Please translate it in a way that fits the standard phrasing for a "Portfolio" page in the target language, considering the common usage in websites for that language.
		title: __('Portfolio', 'extendify-local'),
		// translators: This string represents the slug of a "Portfolio" page on a website that showcases a collection of work. Please translate it in a way that fits a slug for a "Portfolio" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('portfolio', 'extendify-local'),
		alias: ['portfolio'],
	},
	pricing: {
		// translators: This string represents the title of a "Pricing" page on a website that lists the pricing of products or services. Please translate it in a way that fits the standard phrasing for a "Pricing" page in the target language, considering the common usage in websites for that language.
		title: __('Pricing', 'extendify-local'),
		// translators: This string represents the slug of a "Pricing" page on a website that lists the pricing of products or services. Please translate it in a way that fits a slug for a "Pricing" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('pricing', 'extendify-local'),
		alias: ['pricing'],
	},
	products: {
		// translators: This string represents the title of a "Products" page on a website that lists products. Please translate it in a way that fits the standard phrasing for a "Products" page in the target language, considering the common usage in websites for that language.
		title: __('Products', 'extendify-local'),
		// translators: This string represents the slug of a "Products" page on a website that lists products. Please translate it in a way that fits a slug for a "Products" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('products', 'extendify-local'),
		alias: [
			'products',
			'best-sellers-products',
			'featured-products',
			'new-arrivals-product',
			'on-sale-products',
			'product-section',
			'products-by-category',
			'products-categories',
			'top-rated-products',
		],
	},
	quote: {
		// translators: This string represents the title of a "Quote" page on a website that allows visitors to request a quote. Please translate it in a way that fits the standard phrasing for a "Quote" page in the target language, considering the common usage in websites for that language.
		title: __('Quote', 'extendify-local'),
		// translators: This string represents the slug of a "Quote" page on a website that allows visitors to request a quote. Please translate it in a way that fits a slug for a "Quote" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('quote', 'extendify-local'),
		alias: ['quote'],
	},
	reservation: {
		// translators: This string represents the title of a "Reservation" page on a website that allows visitors to make a reservation. Please translate it in a way that fits the standard phrasing for a "Reservation" page in the target language, considering the common usage in websites for that language.
		title: __('Reservation', 'extendify-local'),
		// translators: This string represents the slug of a "Reservation" page on a website that allows visitors to make a reservation. Please translate it in a way that fits a slug for a "Reservation" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('reservation', 'extendify-local'),
		alias: ['reservation'],
	},
	resources: {
		// translators: This string represents the title of a "Resources" page on a website that provides resources. Please translate it in a way that fits the standard phrasing for a "Resources" page in the target language, considering the common usage in websites for that language.
		title: __('Resources', 'extendify-local'),
		// translators: This string represents the slug of a "Resources" page on a website that provides resources. Please translate it in a way that fits a slug for a "Resources" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('resources', 'extendify-local'),
		alias: ['resources', 'resource'],
	},
	serviceArea: {
		// translators: This string represents the title of a "Service Area" page on a website that shows the service area of a business, including a map. Please translate it in a way that fits the standard phrasing for a "Service Area" page in the target language, considering the common usage in websites for that language.
		title: __('Service Area', 'extendify-local'),
		// translators: This string represents the slug of a "Service Area" page on a website that shows the service area of a business, including a map. Please translate it in a way that fits a slug for a "Service Area" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('service-area', 'extendify-local'),
		alias: ['service-area'],
	},
	services: {
		// translators: This string represents the title of a "Services" page on a website that lists services. Please translate it in a way that fits the standard phrasing for a "Services" page in the target language, considering the common usage in websites for that language.
		title: __('Services', 'extendify-local'),
		// translators: This string represents the slug of a "Services" page on a website that lists services. Please translate it in a way that fits a slug for a "Services" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('services', 'extendify-local'),
		alias: ['services'],
	},
	specials: {
		// translators: This string represents the title of a "Specials" page on a website that lists special offers. Please translate it in a way that fits the standard phrasing for a "Specials" page in the target language, considering the common usage in websites for that language.
		title: __('Specials', 'extendify-local'),
		// translators: This string represents the slug of a "Specials" page on a website that lists special offers. Please translate it in a way that fits a slug for a "Specials" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('specials', 'extendify-local'),
		alias: ['specials'],
	},
	team: {
		// translators: This string represents the title of a "Team" page on a website that introduces the team members. Please translate it in a way that fits the standard phrasing for a "Team" page in the target language, considering the common usage in websites for
		title: __('Team', 'extendify-local'),
		// translators: This string represents the slug of a "Team" page on a website that introduces the team members. Please translate it in a way that fits a slug for a "Team" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('team', 'extendify-local'),
		alias: ['team'],
	},
	testimonials: {
		// translators: This string represents the title of a "Testimonials" page on a website that showcases testimonials from customers. Please translate it in a way that fits the standard phrasing for a "Testimonials" page in the target language, considering the common usage in websites for that language.
		title: __('Testimonials', 'extendify-local'),
		// translators: This string represents the slug of a "Testimonials" page on a website that showcases testimonials from customers. Please translate it in a way that fits a slug for a "Testimonials" page in the target language, considering the common usage in websites for that language. Make sure to keep the slug lowercase and url-friendly.
		slug: __('testimonials', 'extendify-local'),
		alias: ['testimonials', 'testimonial'],
	},
};
